unit IWCompMemo32;
{PUBDIST}

interface

uses
  {$IFDEF VSNET}
  System.ComponentModel, System.Drawing, IWNetClasses,
  {$ELSE}
  Classes,
    {$IFDEF Linux}
    IWCLXComponent, IWCLXClasses,
    {$ELSE}
    IWVCLComponent, IWVCLClasses,
    {$ENDIF}
  {$IFDEF Linux}QControls,{$ELSE}Controls,{$ENDIF}
  {$ENDIF}
  IWBaseControl, IWHTMLTag, IWControl32, IWColor, IWRenderContext,
  IWBaseInterfaces;

type
  TIWCustomMemo32 = class(TIWCustomControl32, IIWInputControl)
  private
    procedure OnItemsChange( ASender : TObject );
  protected
    FLines: TIWStringList;
    FReadOnly: Boolean;
    FRequired: Boolean;
    FEndsWithCRLF: Boolean;
    FWantReturns: Boolean;
    FColumCount: Integer;
    FRowCount: Integer;
    //
    procedure SetColumCount(const Value: Integer);
    procedure SetRowCount(const Value: Integer);
    procedure SetLines(const AValue: TIWStringList);
    procedure SetValue(const AValue: string); virtual;
    procedure InitControl; override;
  {$IFDEF CLR}
  strict protected
  {$ELSE}
  protected
  {$ENDIF}
    {$IFDEF VSNET}
    function getText: string; reintroduce;
    procedure setText(AValue: string); reintroduce;
    {$ENDIF}
    procedure Dispose(ADispose: Boolean); override;
  public
    procedure Clear; virtual;
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    property Text: string read getText write setText;
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property Lines: TIWStringList read FLines write SetLines;

  published
    property Editable;
    property ExtraTagParams;

    property ReadOnly: Boolean read FReadOnly write FReadOnly;

    property RowCount: Integer read FRowCount write SetRowCount;

    property ColumCount: Integer read FColumCount write SetColumCount;

    property TabOrder;

    property WantReturns: Boolean read FWantReturns write FWantReturns;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWMemo32.bmp}
  TIWMemo32 = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWMemo32), 'TIWMemo32.bmp')]
  {$ENDIF}
  TIWMemo32 = class(TIWCustomMemo32)
  published
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    property WebFont;
    {$ELSE}
    property Font;
    {$ENDIF}
    property Lines;
  end;

implementation

uses
  SysUtils,
  IWCompText32, SWSystem, IWForm32, IWGlobal, IWUtils;
{ TIWCustomMemo32 }

{$IFDEF VSNET}
function TIWCustomMemo32.getText: string;
begin
  Result := FLines.Text;
end;


procedure TIWCustomMemo32.setText(AValue: string);
begin
  FLines.Text := AValue;
end;
{$ENDIF}

procedure TIWCustomMemo32.InitControl;
begin
  inherited;
  FLines := TIWStringList.Create;
  FLines.OnChange := OnItemsChange;
  FNeedsFormTag := True;
  Height := 121;
  Width := 121;
  FEndsWithCRLF := true;
end;

procedure TIWCustomMemo32.Dispose(ADispose: Boolean);
begin
  FreeAndNil(FLines);
  inherited;
end;

function TIWCustomMemo32.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  LDest: TIWText32;
  S: String;
begin
  Result := nil;
  if Editable then begin
    Result := TIWHTMLTag.CreateTag('TEXTAREA'); try
      // Netscape can handle fonts here using method in TIWEdit, but IE cannot.
      Result.AddStringParam('NAME', HTMLName);
      // Result.AddIntegerParam('ROWS', Height div 16);
      // Result.AddIntegerParam('COLS', Width div 7);
      Result.AddIntegerParam('ROWS', RowCount);
      Result.AddIntegerParam('COLS', ColumCount);
      Result.Add(iif(ReadOnly, 'READONLY'));
      S := FLines.Text;
      if not FEndsWithCRLF and (Length(S) >= Length(sLineBreak)) then
        SetLength(S, Length(S) - Length(sLineBreak));
      Result.Contents.AddText(S);
    except FreeAndNil(Result); raise; end;
  end else begin
    LDest := TIWText32.Create{$IFNDEF VSNET}(Self){$ENDIF}; try
      LDest.Name := Self.Name;
//      LDest.Color := Self.Color;
      LDest.ExtraTagParams := Self.ExtraTagParams;
      {$IFDEF CLR}
      LDest.WebFont.Assign(Self.WebFont);
      {$ELSE}
      LDest.Font.Assign(Self.Font);
      {$ENDIF} 
      LDest.RawText := False;
      LDest.Width := Self.Width;
      LDest.Height := Self.Height;
      LDest.Lines := Lines;
      LDest.WantReturns := Self.WantReturns;
      LDest.ConvertSpaces := False;
      Result := LDest.RenderHTML(AContext);
    finally FreeAndNil(LDest); end;
  end;
end;

procedure TIWCustomMemo32.SetColumCount(const Value: Integer);
begin
  FColumCount := Value;
end;

procedure TIWCustomMemo32.SetLines(const AValue: TIWStringList);
begin
  FLines.Assign(AValue);
  FEndsWithCRLF := true;
  Invalidate;
end;

procedure TIWCustomMemo32.SetRowCount(const Value: Integer);
begin
  FRowCount := Value;
end;

procedure TIWCustomMemo32.SetValue(const AValue: string);
begin
  if RequiresUpdateNotification(Parent) then begin
    UpdateNotifiedInterface(Parent).NotifyUpdate(Self,AValue);
  end;
  FLines.Text := AValue;
  FEndsWithCRLF := FLines.Text = AValue;
  // Will use Text internally to set the real value
  Text := AValue;
  Invalidate;
end;

procedure TIWCustomMemo32.Clear;
begin
  Lines.Clear;
end;

procedure TIWCustomMemo32.OnItemsChange(ASender: TObject);
begin
  Invalidate;
end;

end.
